/* ------------------------ Variables ------------------------ */

var API_URL = "https://intranet.istrfa.edu.pe/api/api_alumno.php";

var auth = localStorage.getItem("auth");

/* ------------------------ APP Init ------------------------ */
var app = new Framework7({
  // App root element
  root: '#app',
  // App Name
  name: 'RFA App',
  // App id
  id: 'com.rfa.app',
  on: {
    init: function () {
      checkVersion(10);
      setUser();
      fetchNews();
    },
  },
  view: {
    pushState: true,
    animate: false
  },
  routes: [
    {
      path: '/courses/',
      url: 'courses.html',
      on: {
        pageInit: function(){
          fetchCourses();
        } 
      }
    },
    {
      path: '/notes/',
      url: 'notes.html',
      on: {
        pageInit: function(){
          fetchSems();
          fetchNotes();
        } 
      }
    },
    {
      path: '/news/:id/',
      url: 'news.html',
      on: {
        pageInit: function(){
          fetchNew();
        } 
      }
    },
    {
      path: '/about/',
      url: 'about.html'
    }
  ],
  smartSelect: {
    openIn: 'popover',
    closeOnSelect: true
  },
  touch:{
    materialRipple: false
  }
  
});

var mainView = app.views.create('.view-main');

var loginScreen = app.loginScreen.create({
  content: '<div class="login-screen">\
  <!-- Default view-page layout -->\
  <div class="view">\
    <div class="page">\
      <!-- page-content has additional login-screen content -->\
      <div class="page-content login-screen-content">\
        <!-- Login form -->\
        <form class="card">\
          <div class="list">\
            <img src="img/logo.png" width="100%"/>\
            <ul>\
              <li class="item-content item-input">\
                <div class="item-inner">\
                  <div class="item-title item-label">Usuario</div>\
                  <div class="item-input-wrap">\
                    <input type="text" id="txtuser" autocomplete="off" maxlenght="8" autofocus>\
                    <span class="input-clear-button"></span>\
                  </div>\
                </div>\
              </li>\
              <li class="item-content item-input">\
                <div class="item-inner">\
                  <div class="item-title item-label">Contraseña</div>\
                  <div class="item-input-wrap">\
                    <input type="password" id="txtpass" autocomplete="off">\
                    <span class="input-clear-button"></span>\
                  </div>\
                </div>\
              </li>\
            </ul>\
          </div>\
          <div class="list">\
            <ul>\
              <li>\
                <a href="#" class="button button-outline" id="btn-login">Ingresar</a>\
              </li>\
            </ul>\
            <div class="block-footer">Bienvenido, inicia sesión para continuar</div>\
          </div>\
        </form>\
      </div>\
    </div>\
  </div>\
</div>'
});

/* ------------------------ All ------------------------ */

function checkVersion(version){
  $.post(API_URL,{ type: "version", version: version },function(data){
    data =JSON.parse(data);
    if(data.error == 1){
      window.location.replace("update.html");
    }
  });
  return true;  
}


/* ------------------------ Main.html ------------------------ */

function logout(){
  app.dialog.confirm('¿Estás seguro que deseas salir?', function () {
    localStorage.clear();
    window.location.replace("index.html");
  });
}



function setUser(){
  $("#a_nombre").html(localStorage.getItem("nombre"));
  $("#a_carrera").html(localStorage.getItem("carrera")+'<br>'+'Semestre: '+localStorage.getItem("semestre")+'° - '+localStorage.getItem("turno"));
  $("#a_imagen").html(localStorage.getItem("imagen"));
}

function fetchNews(){
    $("#news").html('<div style="text-align: center;"> <div class="preloader color-blue"><span class="preloader-inner"><span class="preloader-inner-gap"></span><span class="preloader-inner-left"><span class="preloader-inner-half-circle"></span></span><span class="preloader-inner-right"><span class="preloader-inner-half-circle"></span></span></span></div></div>');
    url = "https://istrfa.edu.pe/api/noticias.json.php";
    $.get(url,function(data){
      data = JSON.parse(data);
      var html = '';
      data.forEach(function(i){
        html += '<li>\
                  <a href="/news/'+i.n_id+'/" class="item-link item-content">\
                    <div class="item-media"><img src="./img/news.svg" width="44" height="44" /></div>\
                    <div class="item-inner">\
                      <div class="item-title-row">\
                        <div class="item-title">'+i.n_titulo+'</div>\
                      </div>\
                      <div class="item-subtitle">'+i.n_fecha+'</div>\
                    </div>\
                  </a>\
                </li>';
        
      });
      $("#news").html(html);
    }).fail(function(){
     $("#news").html('<button class="col button color-red" onclick="fetchNews()">Sin conexión a internet <i class="icon material-icons">refresh</i></button>');
    });
}

/* ------------------------ Courses.html ------------------------ */

function fetchCourses(){

  $("#courses_info").html(localStorage.getItem("carrera")+" - "+localStorage.getItem("semestre")+"° SEM");
  
  $("#res_courses").html('<div style="text-align: center;"> <div class="preloader color-blue"><span class="preloader-inner"><span class="preloader-inner-gap"></span><span class="preloader-inner-left"><span class="preloader-inner-half-circle"></span></span><span class="preloader-inner-right"><span class="preloader-inner-half-circle"></span></span></span></div></div>');
    url = "https://istrfa.edu.pe/api/noticias.json.php";

  $.post(API_URL,{ type: "cursos", alu: localStorage.getItem("dni")},function(data){
    data =JSON.parse(data);
    var html = '';
    if(data.error == 1){
      html += '<div class="block block-strong text-align-center">No se han encontrado datos.</div>';
    }else{
      data.forEach(function(i){
        html += '<div class="card">\
      <div class="list media-list">\
      <ul>\
        <li>\
          <div class="item-content">\
            <div class="item-media"><img src="img/book.svg" width="44"/></div>\
            <div class="item-inner">\
              <div class="item-title-row">\
                <div class="item-title">'+i.unidad+'</div>\
              </div>\
              <div class="item-subtitle">'+i.docente+'</div>\
            </div>\
          </div>\
        </li>\
        <li>\
          <div class="item-content">\
            <div class="item-media"><img src="img/calendar.svg" width="44"/></div>\
            <div class="item-inner">\
              <div class="item-title-row">\
                <div class="item-title">Inicio: '+i.fecha1+'</div>\
              </div>\
              <div class="item-subtitle">Fin: '+i.fecha2+'</div>\
            </div>\
          </div>\
        </li>\
      </ul>\
      </div> \
    </div>';
      });
    }
    
    $("#res_courses").html(html);

  }).fail(function(){
     $("#res_courses").html('<button class="col button color-red" onclick="fetchCourses()">Sin conexión a internet <i class="icon material-icons">refresh</i></button>');
  });
}

/* ------------------------ Notes.html ------------------------ */

function fetchSems(){
s = localStorage.getItem("semestre");
html = '';

for(i=1;i<=6;i++){
  html += '<option '+(i == s ? 'selected' : '' )+' value="'+i+'">Semestre '+i+'</option>';
}

$("#filtro").html(html);
$("#filtro_label").html("Semestre "+s);
}

function fetchNotes(){
  $("#res_notes").html('<td colspan="8" align="center"><div class="preloader color-blue"><span class="preloader-inner"><span class="preloader-inner-gap"></span><span class="preloader-inner-left"><span class="preloader-inner-half-circle"></span></span><span class="preloader-inner-right"><span class="preloader-inner-half-circle"></span></span></span></div></td>');
  sem = $("#filtro").val();
  $.post(API_URL,{ type: "notas", alu: localStorage.getItem("dni"), sem: sem },function(data){
    data =JSON.parse(data);
    var html = '';
    if(data.error == 1){
      html += '<tr><td colspan="8" align="center">No se han encontrado datos.</td></tr>';
    }else{
      data.forEach(function(i){
        html += '<tr>\
                  <td class="label-cell">'+i.ud_nombre+'</td>\
                  <td class="numeric-cell">'+(i.nota_c1 != null ? i.nota_c1 :  '-')+'</td>\
                  <td class="numeric-cell">'+(i.nota_c2 != null ? i.nota_c2 :  '-')+'</td>\
                  <td class="numeric-cell">'+(i.nota_c3 != null ? i.nota_c3 :  '-')+'</td>\
                  <td class="numeric-cell">'+(i.nota_c4 != null ? i.nota_c4 :  '-')+'</td>\
                  <td class="numeric-cell">'+(i.nota_c5 != null ? i.nota_c5 :  '-')+'</td>\
                  <td class="numeric-cell">'+(i.nota_final != null ? i.nota_final :  '')+'</td>\
                  <td class="label-cell">'+ver_tipo(i.nota_tipo)+'</td>\
                </tr>';
      });
    }
    
    $("#res_notes").html(html);
  }).fail(function(){
    $("#res_notes").html('<td colspan="3" align="center"><button class="col button color-red" onclick="fetchNotes()">Sin conexión a internet <i class="icon material-icons">refresh</i></button></td>');
  });
}

function ver_tipo(tipo){
  var type;
  switch(tipo){
    case '1':
      type = '<span class="badge color-blue">REGULAR</span>';
      break;
    case '2':
      type = '<span class="badge color-orange">RECUPERACION</span>';
      break;
    case '3':
      type = '<span class="badge color-red">REPITENCIA</span>';
  }
  return type;
}

/* ------------------------ News.html ------------------------ */

function fetchNew(){
   $("#n_titulo").html("Ver Noticia");
   $("#n_fecha").html("Cargando...");
   $("#n_contenido").html('<div style="text-align: center;"> <div class="preloader color-blue"><span class="preloader-inner"><span class="preloader-inner-gap"></span><span class="preloader-inner-left"><span class="preloader-inner-half-circle"></span></span><span class="preloader-inner-right"><span class="preloader-inner-half-circle"></span></span></span></div></div>');
  id = app.view.main.router.currentRoute.params.id;
  url = "https://istrfa.edu.pe/api/noticias.json.php";
  $.post(url,{ id: id },function(data){
    data = JSON.parse(data);
    contenido = data[0].n_contenido.replace(/noticias\/imagenes/g, "https://istrfa.edu.pe/admin/noticias/imagenes");
    fecha = new Date(data[0].n_fecha);
    $("#n_titulo").html(data[0].n_titulo);
    $("#n_fecha").html(fecha.toLocaleDateString("es-ES",{year: 'numeric', month: 'long', day: 'numeric'}));
    $("#n_contenido").html(contenido);
    $("#n_contenido a").addClass("external");
    $("#n_contenido *").attr("style","");

  }).fail(function(){
    $("#n_titulo").html("Error");
    $("#n_fecha").html("Ha ocurrido un error al cargar la noticia:");
    $("#n_contenido").html('<button class="col button color-red" onclick="fetchNew()">Sin conexión a internet <i class="icon material-icons">refresh</i></button>');
  });
}


